
#ifndef _1_CRYS_SEP_ATP_RND_Acceptance_h_H
#define _1_CRYS_SEP_ATP_RND_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_RND_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
typedef struct TST_RND_TestDataStruct{	
	DxUint8_t	TST_RND_Output1[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 	TST_RND_Output2[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
} TST_RND_TestDataStruct;

/******** Public Variables ********/
/******** Public Functions ********/
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RND_No_Reset         
* 
* Inputs:
* RNDSize - size of random vector to generate
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for Random API's 
*  Random vector size - 750
* Algorithm:       
* 1. Call the CRYS_RND_GenerateVector function to generate a random value
* 2. Call the CRYS_RND_GenerateVector to generate a random second random value
* 3. Compare the random numbers and verify the are different                                               
*
**************************************************************************************/                                
CRYSError_t SEPQA_RND_No_Reset(DxUint16_t	RNDSize,
							   DxUint8_t   *FailureFunctionNameOut_ptr);


/***********************************************************************
* Function Name:                                                           
*  SEPQA_RND_Reset         
* 
* Inputs:
* RNDSize - size of random vector to generate
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for Random API's 
*  Random vector size - 750
* Algorithm:       
* 1. Call the CRYS_RND_GenerateVector function to generate a random value
* 2. Call the CRYS_RND_GenerateVector to generate a random second random value
* 3. Compare the random numbers and verify the are different                                               
*
**************************************************************************************/                                
CRYSError_t SEPQA_RND_Reset(DxUint16_t	RNDSize,
							DxUint8_t   *FailureFunctionNameOut_ptr);






#ifdef __cplusplus
}
#endif

#endif


